/*****************************************************************************
*  LPC43xx SCT demo program
*
*  Use SCT timer to generate four-channel PWM
*  SCT_IN0   (pin P2_4)  is used as ABORT input
*  SCT0_OUT0 (pin P2_8   is green trace  = PWM1
*  SCT0_OUT1 (pin P2_7)  is red trace    = PWM2
*  SCT0_OUT2 (pin P2_10) is yellow trace = PWM3
*  SCT0_OUT3 (pin P2_9)  is blue trace   = PWM4
*****************************************************************************/
#include "nxp_lpc43xx.h"
#include "mcb4300.h"

extern void SCT_Init(void);

volatile uint32_t numPwmCycles;
volatile int      pwmAborted;
volatile int      pwmPhase;

void SCT_IRQHandler(void)
{
  uint32_t status = LPC_SCT->EVFLAG;

    if (status & (1 << 0))                                 // event 0 irq?
    {
        ++numPwmCycles;                                    // interrupt once per PWM cycle
    }
    if (status & (1 << 5))                                 // event 5 irq?
    {
        pwmAborted = 1;                                    // Abort interrupt
    }
    LPC_SCT->EVFLAG = status;                              // clear interrupt flag
}

int main (void)
{
  uint32_t lastCycles;

    SystemCoreClockUpdate ();                              // Update system core clock

    LPC_CCU1->CLK_M4_SCT_CFG  = (1 << 0);                  // enable SCT clock in CCU1 

    MCB4300_Init();                                        // Initialize MCB4300 board stuff
    SCT_Init();                                            // Initialize SCT1

    while (1)                                              // loop forever
    {
       	if (numPwmCycles != lastCycles)
       	{
            lastCycles = numPwmCycles;
   		    if ((lastCycles % 5) == 0)                     // every few PWM cycles change the duty cycles
   		    {
                LPC_SCT->CONFIG |= (1 << 7);               // NORELOAD_L (U)
                if (pwmPhase == 0)
                {
                	LPC_SCT->MATCHREL[1].U = 200000;
                	LPC_SCT->MATCHREL[3].U = 700000;
                }
                else
                {
                	LPC_SCT->MATCHREL[1].U = 950000;
                	LPC_SCT->MATCHREL[3].U = LPC_SCT->MATCHREL[0].U;	// duty cycle 0 (test conflict resolution)
                }
                LPC_SCT->CONFIG &= ~(1 << 7);              // NORELOAD_L (U)

                ++pwmPhase;
                if (pwmPhase > 1)
                {
                    pwmPhase = 0;
                }
            }
        }
        if (pwmAborted)          /* Demo: Poll ABORT input, and restart timer if abort condition has gone. */
        {
            while (!(LPC_SCT->INPUT & (1 << 0))) ;

            LPC_SCT->CTRL_U &= ~(1 << 2);                  /* HALT_L (U) */
            pwmAborted = 0;
        }
    }
}
